--T-SQL Window Function Deep Dive
--2. Window Aggregates

USE AdventureWorks2014;
GO

--Calculate aggregates without an aggregate query
--with window aggregate functions
--Only PARTITION BY and () supported 2005 - 2008 R2
SELECT TotalDue, OrderDate, SalesOrderID, CustomerID, 
	 SUM(TotalDue)OVER() AS TotalSales
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID;

--Add PARTITION BY
SELECT TotalDue, OrderDate, SalesOrderID, CustomerID, 
	SUM(TotalDue) OVER(Partition by CustomerID) AS TotalCustomerSales
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID;


--Add a Window Aggregate to an Aggreate query?
--Here is a typical query
SELECT CustomerID, SUM(TotalDue) AS CustTotal,
	AVG(TotalDue) AS CustAvg
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;

--Add a grand total
SELECT CustomerID, SUM(TotalDue) AS CustTotal,
	AVG(TotalDue) AS CustAvg,
	SUM(TotalDue) OVER() AS GrandTotal
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;

--The window function must follow the 
--same rules as select list
SELECT CustomerID, SUM(TotalDue) AS CustTotal,
	AVG(TotalDue) AS CustAvg,
	SUM(SUM(TotalDue)) OVER() AS GrandTotal
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;




